/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.compat.botarium.options;

import dev.architectury.injectables.annotations.ExpectPlatform;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import me.codexadrian.tempad.api.options.TempadOption;
import me.codexadrian.tempad.api.options.TempadOptionApi;
import me.codexadrian.tempad.common.Tempad;
import me.codexadrian.tempad.common.compat.botarium.options.fabric.FluidOptionImpl;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3611;

public class FluidOption
extends TempadOption {
    @Override
    public boolean canTimedoorOpen(class_1657 player, class_1799 stack) {
        ItemFluidContainer fluidStorage = FluidApi.getItemFluidContainer((ItemStackHolder)new ItemStackHolder(stack));
        if (fluidStorage == null) {
            return false;
        }
        return !((FluidHolder)fluidStorage.getFluids().get(0)).isEmpty() && ((FluidHolder)fluidStorage.getFluids().get(0)).getFluidAmount() >= (long)TempadOptionApi.getFuelCost(stack) && ((FluidHolder)fluidStorage.getFluids().get(0)).is(Tempad.TEMPAD_LIQUID_FUEL_TAG);
    }

    @Override
    public void addToolTip(class_1799 stack, class_1937 level, List<class_2561> components, class_1836 flag) {
        ItemFluidContainer fluidStorage = FluidApi.getItemFluidContainer((ItemStackHolder)new ItemStackHolder(stack));
        if (fluidStorage == null) {
            return;
        }
        components.add((class_2561)class_2561.method_43469((String)"tempad_option.tempad.fluid", (Object[])new Object[]{FluidOption.getFluidName(((FluidHolder)fluidStorage.getFluids().get(0)).getFluid()), FluidHooks.toMillibuckets((long)((FluidHolder)fluidStorage.getFluids().get(0)).getFluidAmount()), FluidHooks.toMillibuckets((long)fluidStorage.getTankCapacity(0))}).method_27692(class_124.field_1080));
    }

    @Override
    public void onTimedoorOpen(class_1657 player) {
        class_1799 stack = TeleportUtils.findTempad(player);
        ItemStackHolder holder = new ItemStackHolder(stack);
        ItemFluidContainer fluidStorage = FluidApi.getItemFluidContainer((ItemStackHolder)holder);
        if (fluidStorage == null) {
            return;
        }
        FluidHolder fluid = (FluidHolder)fluidStorage.getFluids().get(0);
        fluid.setAmount((long)TempadOptionApi.getFuelCost(stack));
        fluidStorage.extractFluid(fluid, false);
        if (holder.isDirty()) {
            TeleportUtils.findAndReplaceTempad(player, holder.getStack());
        }
    }

    @Override
    public boolean isDurabilityBarVisible(class_1799 stack) {
        return true;
    }

    @Override
    public double getPercentage(class_1799 stack) {
        ItemFluidContainer fluidStorage = FluidApi.getItemFluidContainer((ItemStackHolder)new ItemStackHolder(stack));
        if (fluidStorage == null || fluidStorage.isEmpty()) {
            return 0.0;
        }
        return (double)((FluidHolder)fluidStorage.getFluids().get(0)).getFluidAmount() / (double)fluidStorage.getTankCapacity(0);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2561 getFluidName(class_3611 fluid) {
        return FluidOptionImpl.getFluidName(fluid);
    }
}

